define([
    'modules/page/popup/external-nav-popup-view',
    'modules/learn-about-community-care/learn-about-community-care-popup-view',
], function(ExternalNavigationWarningPopup, HelpPopupView) {
    'use strict';

    describe('Learn About Community Care Popup', function() {
        var view;
        var $view;

        beforeEach(function() {
            spyOn(ExternalNavigationWarningPopup.prototype, 'openPopup');

            view = new HelpPopupView({elAfterClose: '.element-for-focus'});

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2.ui-title').text()).toEqual('Learn About Community Care');
        });

        it('has the required emergency paragraphs', function() {
            expect($view.find('.ui-content p:nth-of-type(1)').text())
                .toEqual('The Veterans Choice Program (VCP), part of Community Care, allows Veterans who are already enrolled in VA Healthcare to receive health care in their community, while still having access to their regular VA health care. Under the VCP, Veterans who have to wait more than 30 days or travel over 40 miles are able to receive care in the community, connecting them to timely and convenient access to health care. VCP 40 mile eligible Veterans will now be able to submit scheduling requests directly through the VA Appointments app. ');
            expect($view.find('.ui-content p:nth-of-type(2)').text())
                .toEqual('To learn more information about the Veterans Choice Program and to see if you are eligible visit: https://www.DOMAIN.EX/opa/choiceact/');
            expect($view.find('.ui-content p:nth-of-type(2) a').attr('href'))
                .toEqual('https://www.DOMAIN.EX/opa/choiceact/');
            expect($view.find('.ui-content p:nth-of-type(3)').text())
                .toEqual('To access a current list of approved providers, visit: https://www.DOMAIN.EX/opa/apps/locator/index.html');
            expect($view.find('.ui-content p:nth-of-type(3) a').attr('href'))
                .toEqual('https://www.DOMAIN.EX/opa/apps/locator/index.html');
        });

        it('shows a warning popup for external links in the notification text body', function() {
            view.$el.find('.external-link').click();
            expect(ExternalNavigationWarningPopup.prototype.openPopup).toHaveBeenCalled();
        });

        it('has an OK button', function() {
            var loginBtn = $view.find('#learncc-ok-btn');
            expect(loginBtn.text()).toEqual('OK');
        });
    });
});
TTTT